<?php

/**
 * I am THE file that defines the Dust Hunters admin specific functionalities
 * I extend Glb_Plugin_Bud, and take profit of all it's functionalities
 *
 * This file is distributed under the same license as the {{generator_package}} package.
 *
 * @since             {{generator_version}}
 * @link              {{generator_link}}
 * @author            {{generator_author}}
 * @package           {{generator_package}}
 */
class Glb_{{generator_sname_wc_u}}_Admin extends Glb_Plugin_Bud {

    public function __construct($plugin) {
        parent::__construct($plugin);

        // add sub menu. No need to add the main menu, as it should be under the Gloubi Boulga main admin menu
        $this->plugin->add_admin_sub_menu('glb_admin_page', '{{generator_sname_fwc_s}}', '{{generator_sname_fwc_s}}',
            'manage_options', 'glb_{{generator_sname_lc_u}}_admin_page', array($this, 'glb_{{generator_sname_lc_u}}_admin_page')
        );
        <<GENERATOR_DATABASE// add an ajax service if you need
        $this->plugin->add_action( 'wp_ajax_{{generator_sname_lc_u}}_admin_service',
            array($this, '{{generator_sname_lc_u}}_admin_service') );GENERATOR_DATABASE>>
    }

    <<GENERATOR_DATABASE/*
     * The service, that
     */
    public function {{generator_sname_lc_u}}_admin_service() {

        $data = $this->request->get_post();

        // check permissions
        // $this->request->check_permissions('IS_FROM admin WITH_CAPS manage_options AND glb_{{generator_sname_lc_u}}_admin');
        // you need to affect roles to users to do that !

        // check id
        $this->request->check_input('id', $data['id'], '{{generator_main_use_plur_lc_u}}_id');


        // check that request is well formed
        if (Glb_Hash::one_empty($data, ['method', 'action', 'id'])) {
            $this->request->set_json_error(400, 'redirect:referer', true);
        }

        if ($data['method'] === 'delete') {
            // deletion required

            // perform a lot of checks to avoid hacks

            // check nonce
            $this->request->check_nonce('glb-{{generator_sname_lc_u}}-delete-' . $data['id']);

            // log the action in file (for example)
            Glb_Log::trace('{{generator_sname_wc_u}} deletion requested for ' . $data['id'], $data);

            // log the action in database (for example)
            Glb_Db_Log::instance($this->plugin)->log('delete', 'admin', [__glbr('{{generator_main_use_sing_fwc_u}} « %s » deleted'), $data['name']], null, 'info');

            // select item in database before deletion
            $item = $this->plugin->database->select_first('glb_dusters_dusts', '*', 'id = %d', [$data['id']]);

            // perform action
            $this->plugin->database->delete('glb_{{generator_sname_lc_u}}_{{generator_main_use_plur_lc_u}}', ['id' => $data['id']], ['%d']);

            // add an admin notice
            $this->notices->add(__glb('{{generator_main_use_sing_fwc_u}} « %s » was deleted (we hope it was voluntary).', $item['name']));

        } else if ($data['method'] === 'edit') {

            if ($this->request->get_post('save')) {
                // save required

                // check nonce
                $this->request->check_nonce('glb-{{generator_sname_lc_u}}-edit-' . $data['id']);

                // log the action in file
                Glb_Log::trace('{{generator_sname_wc_u}} save requested for ' . $data['id'], $data);

                // do action
                if ( $data['id'] == '~new' ) {

                    // Insert in table
                    $data['id'] = $this->plugin->database->insert('glb_{{generator_sname_lc_u}}_{{generator_main_use_plur_lc_u}}', ['name' => $data['name'], 'description' => $data['description'], 'modified' => date('Y-m-d H:i:s'), 'created' => date('Y-m-d H:i:s'), 'status' => (!empty($data['status'] ? 1 : 0))], ['%s', '%s', '%s', '%s', '%d']);
                    // Database log
                    Glb_Db_Log::instance()->log('{{generator_main_use_sing_lc_u}}_add', GLB_ACTIVITY_TYPE_ADMIN_ACTION, [__glbr('{{generator_main_use_sing_fwc_u}} « %s » created'), $data['name']], null, 'info', ['{{generator_main_use_sing_lc_u}}', $data['id']]);
                    // Add an admin notice
                    $this->notices->add(__glb('{{generator_main_use_sing_fwc_u}} « %s » was created.', $data['name']));

                } else {

                    // Update in table
                    $this->plugin->database->update('glb_{{generator_sname_lc_u}}_{{generator_main_use_plur_lc_u}}', ['name' => $data['name'], 'description' => $data['description'], 'modified' => date('Y-m-d H:i:s'), 'created' => date('Y-m-d H:i:s'), 'status' => (!empty($data['status'] ? 1 : 0))], ['id' => $data['id']], ['%s', '%s', '%s', '%s'], ['%d']);

                    // Database log
                    Glb_Db_Log::instance()->log('{{generator_main_use_sing_lc_u}}_update', GLB_ACTIVITY_TYPE_ADMIN_ACTION, [__glbr('{{generator_main_use_sing_fwc_u}} « %s » updated'), $data['name']], null, 'info', ['{{generator_main_use_sing_lc_u}}', $data['id']]);

                    // Add an admin notice
                    $this->notices->add(__glb('{{generator_main_use_sing_fwc_u}} « %s » was updated.', $data['name']));

                }

                // Set highlights to show the last modified item
                $this->session->set('{{generator_sname_lc_u}}.highlights.{{generator_main_use_plur_lc_u}}.id', $data['id']);
                $this->plugin->render_json('ok', 'redirect:referer');

            } else {

                $this->request->check_nonce('glb-{{generator_sname_lc_u}}-edit-' . $data['id']);

                // create html for edition form
                if ($data['id'] == '~new') {
                    $item = ['id' => '~new', 'name' => 'test (new)', 'description' => 'description (new)', 'status' => 0];
                } else {
                    $item = $this->plugin->database->select_first('glb_{{generator_sname_lc_u}}_{{generator_main_use_plur_lc_u}}', '*', "id = '%d'", [$data['id']]);
                }

                $this->plugin->render_json(
                    [ ],
                    [ 'type' => 'modal', 'value' => [
                        'title' => ($data['id'] == '~new') ? __glb('New {{generator_main_use_sing_lc_u}}') : __glb('{{generator_main_use_sing_fwc_u}} « %s »', $item['name']),
                        'height' => '0.75*$(window).height()',
                        'content' => Glb_Html::get('form')->html([
                            'action' => admin_url('admin-ajax.php'),
                            'class' => 'glb-{{generator_sname_lc_u}}-admin-form glb-full-height',
                            'fieldset.class' => 'glb-full-height',
                            'method' => 'POST',
                            'content' =>
                                '<div class="glb-filled-container">' .
                                '<div class="glb-filled-child-fixed">' .
                                Glb_Html::get('hidden')->html(['name' => 'id', 'value' => $item['id']]) .
                                Glb_Html::get('hidden')->html(['name' => 'glb_nonce', 'value' => $this->request->create_nonce('glb-{{generator_sname_lc_u}}-edit-' . $item['id'])]) .
                                Glb_Html::get('hidden')->html(['name' => 'action', 'value' => '{{generator_sname_lc_u}}_admin_service']) .
                                Glb_Html::get('hidden')->html(['name' => 'method', 'value' => 'edit']) .
                                Glb_Html::get('hidden')->html(['name' => 'save', 'value' => '1']) .
                                Glb_Html::get('checkbox')->html(['name' => 'status', 'value' => $item['status'], 'label' => __glb('Enabled'), 'with_label' => '1']) .
                                Glb_Html::get('text')->html(['name' => 'name', 'value' => glb_esch($item['name']), 'label' => __glb('Name'), 'with_label' => '1']) .
                                Glb_Html::get('text')->html(['name' => 'description', 'value' => glb_esch($item['description']), 'label' => __glb('Description'), 'with_label' => '1']) .
                                '</div></div>'
                        ]),
                        'buttons' => [
                            [ 'label' => __glb('Yep, do it'), 'action' => 'submit-form' ],
                            [ 'label' => __glb('Nope, cancel'), 'action' => 'dismiss-modal' ],
                        ],
                    ]
                    ]);

            }

        }

        // if we raise this point, then we have a problem
        $this->request->set_json_error(400, 'redirect:referer', true);
        wp_die();

    }
    GENERATOR_DATABASE>>
    public function glb_{{generator_sname_lc_u}}_admin_page() {

        $settings = $this->plugin->settings->get();

        if ($this->request->get_get('tab') == 'settings') {

            // save settings if needed
            if ($this->request->get_post('glb_{{generator_sname_lc_u}}_settings_submit') !== null) {

                $this->request->check_nonce('glb-{{generator_sname_lc_d}}-settings-edit');
                $settings = $this->plugin->settings->patch_and_save();

                // add admin notice
                $this->notices->add(__glb('Settings saved.'));

            }

        }

        // render admin page
        $this->plugin->render_template('glb-{{generator_sname_lc_d}}-admin-page', ['settings' => $settings]);
    }

}
